/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class FontSet implements Internal.AutoCloseable {
        constructor($$0: Internal.TextureManager_, $$1: ResourceLocation_)
        close(): void;
        getGlyphInfo($$0: number, $$1: boolean): Internal.GlyphInfo;
        getGlyph($$0: number): Internal.BakedGlyph;
        getRandomGlyph($$0: Internal.GlyphInfo_): Internal.BakedGlyph;
        reload($$0: Internal.List_<Internal.GlyphProvider>): void;
        whiteGlyph(): Internal.BakedGlyph;
        readonly providers: Internal.List<Internal.GlyphProvider>;
    }
    type FontSet_ = FontSet;
    interface DiscreteVoxelShape$IntFaceConsumer {
        abstract consume(arg0: Internal.Direction_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.Direction, arg1: number, arg2: number, arg3: number): void;
    }
    type DiscreteVoxelShape$IntFaceConsumer_ = DiscreteVoxelShape$IntFaceConsumer;
    interface GroupPrincipal extends Internal.UserPrincipal {
        abstract hashCode(): number;
        abstract toString(): string;
        abstract getName(): string;
        abstract equals(arg0: any): boolean;
        implies(arg0: Internal.Subject_): boolean;
        get name(): string
    }
    type GroupPrincipal_ = GroupPrincipal;
    class RandomSpreadFoliagePlacer extends Internal.FoliagePlacer {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_, $$2: Internal.IntProvider_, $$3: number)
        static readonly CODEC: Internal.Codec<Internal.RandomSpreadFoliagePlacer>;
    }
    type RandomSpreadFoliagePlacer_ = RandomSpreadFoliagePlacer;
    class BufferBuilder$RenderedBuffer {
        drawState(): Internal.BufferBuilder$DrawState;
        indexBuffer(): Internal.ByteBuffer;
        vertexBuffer(): Internal.ByteBuffer;
        release(): void;
        isEmpty(): boolean;
        get empty(): boolean
    }
    type BufferBuilder$RenderedBuffer_ = BufferBuilder$RenderedBuffer;
    class StickerBlockEntity extends Internal.SmartBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        playSound(attach: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isAttachedToBlock(): boolean;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        isBlockStateExtended(): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
        get attachedToBlock(): boolean
        get blockStateExtended(): boolean
        computerBehaviour: Internal.AbstractComputerBehaviour;
    }
    type StickerBlockEntity_ = StickerBlockEntity;
    interface RandomAccess {
    }
    type RandomAccess_ = RandomAccess;
    class PigmentIota$Companion$TYPE$1 extends Internal.IotaType<Internal.PigmentIota> {
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.PigmentIota;
    }
    type PigmentIota$Companion$TYPE$1_ = PigmentIota$Companion$TYPE$1;
    interface PipeAttachmentBlockEntity extends Internal.RenderDataBlockEntity {
        getAttachments(be: Internal.BlockEntity_): any[];
        getRenderData(): any;
        get renderData(): any
    }
    type PipeAttachmentBlockEntity_ = PipeAttachmentBlockEntity;
    class SmithingTransformRecipe$Serializer implements Internal.RecipeSerializer<Internal.SmithingTransformRecipe> {
        constructor()
        toNetwork($$0: Internal.FriendlyByteBuf_, $$1: Internal.SmithingTransformRecipe_): void;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson($$0: ResourceLocation_, $$1: Internal.JsonObject_): Internal.SmithingTransformRecipe;
        fromNetwork($$0: ResourceLocation_, $$1: Internal.FriendlyByteBuf_): Internal.SmithingTransformRecipe;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type SmithingTransformRecipe$Serializer_ = SmithingTransformRecipe$Serializer;
    class EnvType extends Internal.Enum<Internal.EnvType> {
        static values(): Internal.EnvType[];
        static valueOf(arg0: string): Internal.EnvType;
        static readonly CLIENT: Internal.EnvType;
        static readonly SERVER: Internal.EnvType;
    }
    type EnvType_ = "server" | "client" | EnvType;
    interface Long2ObjectSortedMap$FastSortedEntrySet <V> extends Internal.ObjectSortedSet<Internal.Long2ObjectMap$Entry<V>>, Internal.Long2ObjectMap$FastEntrySet<V> {
        forEach(arg0: Internal.Consumer_<Internal.Long2ObjectMap$Entry<V>>): void;
        removeLast(): Internal.Long2ObjectMap$Entry<V>;
        subSet(arg0: any, arg1: any): Internal.SortedSet<any>;
        of<K>(arg0: K, arg1: K): Internal.ObjectSet<K>;
        abstract retainAll(arg0: Internal.Collection_<any>): boolean;
        getLast(): Internal.Long2ObjectMap$Entry<V>;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        abstract addAll(arg0: Internal.Collection_<Internal.Long2ObjectMap$Entry<V>>): boolean;
        abstract iterator(arg0: Internal.Long2ObjectMap$Entry_<V>): Internal.ObjectBidirectionalIterator<Internal.Long2ObjectMap$Entry<V>>;
        addLast(arg0: Internal.Long2ObjectMap$Entry_<V>): void;
        stream(): Internal.Stream<Internal.Long2ObjectMap$Entry<V>>;
        abstract toArray<T>(arg0: T[]): T[];
        abstract remove(arg0: any): boolean;
        of<K>(): Internal.ObjectSet<K>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        abstract fastIterator(): Internal.ObjectBidirectionalIterator<Internal.Long2ObjectMap$Entry<V>>;
        spliterator(): Internal.Spliterator<any>;
        abstract removeAll(arg0: Internal.Collection_<any>): boolean;
        of<K>(...arg0: K[]): Internal.ObjectSet<K>;
        removeIf(arg0: Internal.Predicate_<Internal.Long2ObjectMap$Entry<V>>): boolean;
        copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        fastForEach(arg0: Internal.Consumer_<Internal.Long2ObjectMap$Entry<V>>): void;
        abstract fastIterator(arg0: Internal.Long2ObjectMap$Entry_<V>): Internal.ObjectBidirectionalIterator<Internal.Long2ObjectMap$Entry<V>>;
        tailSet(arg0: any): Internal.SortedSet<any>;
        of<K>(arg0: K, arg1: K, arg2: K): Internal.ObjectSet<K>;
        abstract isEmpty(): boolean;
        addFirst(arg0: Internal.Long2ObjectMap$Entry_<V>): void;
        abstract comparator(): Internal.Comparator<Internal.Long2ObjectMap$Entry<V>>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        abstract containsAll(arg0: Internal.Collection_<any>): boolean;
        abstract last(): Internal.Long2ObjectMap$Entry<V>;
        headSet(arg0: any): Internal.SortedSet<any>;
        getFirst(): Internal.Long2ObjectMap$Entry<V>;
        abstract add(arg0: Internal.Long2ObjectMap$Entry_<V>): boolean;
        removeFirst(): Internal.Long2ObjectMap$Entry<V>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        abstract contains(arg0: any): boolean;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        iterator(): Internal.Iterator<any>;
        reversed(): Internal.SequencedSet<any>;
        abstract toArray(): any[];
        abstract size(): number;
        abstract hashCode(): number;
        abstract clear(): void;
        of<K>(arg0: K): Internal.ObjectSet<K>;
        abstract equals(arg0: any): boolean;
        abstract first(): Internal.Long2ObjectMap$Entry<V>;
        parallelStream(): Internal.Stream<Internal.Long2ObjectMap$Entry<V>>;
        get last(): Internal.Long2ObjectMap$Entry<V>
        get empty(): boolean
        get first(): Internal.Long2ObjectMap$Entry<V>
    }
    type Long2ObjectSortedMap$FastSortedEntrySet_<V> = Long2ObjectSortedMap$FastSortedEntrySet<V>;
    class TabSet implements Internal.Serializable {
        constructor(arg0: Internal.TabStop_[])
        getTabAfter(arg0: number): Internal.TabStop;
        getTabCount(): number;
        getTabIndex(arg0: Internal.TabStop_): number;
        getTabIndexAfter(arg0: number): number;
        getTab(arg0: number): Internal.TabStop;
        get tabCount(): number
    }
    type TabSet_ = TabSet;
    class UpwardsBranchingTrunkPlacer extends Internal.TrunkPlacer {
        constructor($$0: number, $$1: number, $$2: number, $$3: Internal.IntProvider_, $$4: number, $$5: Internal.IntProvider_, $$6: Internal.HolderSet_<Internal.Block>)
        static readonly CODEC: Internal.Codec<Internal.UpwardsBranchingTrunkPlacer>;
    }
    type UpwardsBranchingTrunkPlacer_ = UpwardsBranchingTrunkPlacer;
    interface IExtendedParameterList <T> {
        abstract getUniqueness(arg0: number, arg1: number, arg2: number): number;
        abstract getTreeCount(): number;
        abstract isInitialized(): boolean;
        abstract findValuePositional(arg0: Internal.Climate$TargetPoint_, arg1: number, arg2: number, arg3: number): T;
        abstract initializeForTerraBlender(arg0: Internal.RegistryAccess_, arg1: Internal.RegionType_, arg2: number): void;
        abstract getTree(arg0: number): Internal.Climate$RTree<any>;
        get treeCount(): number
        get initialized(): boolean
    }
    type IExtendedParameterList_<T> = IExtendedParameterList<T>;
    interface Promise <V> extends io.netty.util.concurrent.Future<V> {
        abstract isSuccess(): boolean;
        abstract setFailure(arg0: Internal.Throwable_): this;
        abstract syncUninterruptibly(): this;
        abstract tryFailure(arg0: Internal.Throwable_): boolean;
        abstract awaitUninterruptibly(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract awaitUninterruptibly(): this;
        abstract cause(): Internal.Throwable;
        abstract get(): V;
        abstract sync(): this;
        abstract await(arg0: number, arg1: Internal.TimeUnit_): boolean;
        abstract await(arg0: number): boolean;
        abstract removeListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<V>>[]): this;
        abstract addListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<V>>): this;
        abstract setUncancellable(): boolean;
        abstract trySuccess(arg0: V): boolean;
        exceptionNow(): Internal.Throwable;
        abstract awaitUninterruptibly(arg0: number): boolean;
        abstract isCancelled(): boolean;
        state(): Internal.Future$State;
        resultNow(): V;
        abstract addListeners(...arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<V>>[]): this;
        abstract setSuccess(arg0: V): this;
        abstract isDone(): boolean;
        abstract cancel(arg0: boolean): boolean;
        abstract await(): this;
        abstract getNow(): V;
        abstract removeListener(arg0: Internal.GenericFutureListener_<io.netty.util.concurrent.Future<V>>): this;
        abstract isCancellable(): boolean;
        abstract get(arg0: number, arg1: Internal.TimeUnit_): V;
        get success(): boolean
        set failure(arg0: Internal.Throwable_)
        get cancelled(): boolean
        set success(arg0: V)
        get done(): boolean
        get now(): V
        get cancellable(): boolean
    }
    type Promise_<V> = Promise<V>;
    interface LongComparator extends Internal.Comparator<number> {
        abstract compare(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        compare(arg0: number, arg1: number): number;
        comparing<T, U extends Internal.Comparable<any>>(arg0: Internal.Function_<T, U>): Internal.Comparator<T>;
        reverseOrder<T extends Internal.Comparable<any>>(): Internal.Comparator<T>;
        thenComparing(arg0: Internal.Comparator_<number>): Internal.Comparator<number>;
        thenComparing(arg0: Internal.LongComparator_): this;
        thenComparing<U extends Internal.Comparable<any>>(arg0: Internal.Function_<number, U>): Internal.Comparator<number>;
        naturalOrder<T extends Internal.Comparable<any>>(): Internal.Comparator<T>;
        thenComparingLong(arg0: Internal.ToLongFunction_<number>): Internal.Comparator<number>;
        thenComparingDouble(arg0: Internal.ToDoubleFunction_<number>): Internal.Comparator<number>;
        comparingInt<T>(arg0: Internal.ToIntFunction_<T>): Internal.Comparator<T>;
        nullsFirst<T>(arg0: Internal.Comparator_<T>): Internal.Comparator<T>;
        comparingLong<T>(arg0: Internal.ToLongFunction_<T>): Internal.Comparator<T>;
        comparingDouble<T>(arg0: Internal.ToDoubleFunction_<T>): Internal.Comparator<T>;
        nullsLast<T>(arg0: Internal.Comparator_<T>): Internal.Comparator<T>;
        /**
         * @deprecated
        */
        compare(arg0: any, arg1: any): number;
        reversed(): this;
        thenComparing<U>(arg0: Internal.Function_<number, U>, arg1: Internal.Comparator_<U>): Internal.Comparator<number>;
        abstract equals(arg0: any): boolean;
        comparing<T, U>(arg0: Internal.Function_<T, U>, arg1: Internal.Comparator_<U>): Internal.Comparator<T>;
        thenComparingInt(arg0: Internal.ToIntFunction_<number>): Internal.Comparator<number>;
    }
    type LongComparator_ = LongComparator;
    interface AccessorScheduleRuntime {
        abstract getTrain(): Internal.Train;
        abstract setCooldown(arg0: number): void;
        get train(): Internal.Train
        set cooldown(arg0: number)
    }
    type AccessorScheduleRuntime_ = AccessorScheduleRuntime;
    abstract class ItemGenericFood extends Internal.Item {
        constructor(amount: number, saturation: number, isWolfFood: boolean, eatFast: boolean, alwaysEdible: boolean)
        constructor(amount: number, saturation: number, isWolfFood: boolean, eatFast: boolean, alwaysEdible: boolean, stackSize: number)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        static createFood(amount: number, saturation: number, isWolfFood: boolean, eatFast: boolean, alwaysEdible: boolean, potion: Internal.MobEffectInstance_): Internal.FoodProperties;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        abstract onFoodEaten(arg0: Internal.ItemStack_, arg1: Internal.Level_, arg2: Internal.LivingEntity_): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemGenericFood_ = ItemGenericFood;
    class WildRiceFeature extends Internal.Feature<Internal.RandomPatchConfiguration> {
        constructor(configFactoryIn: Internal.Codec_<Internal.RandomPatchConfiguration>)
    }
    type WildRiceFeature_ = WildRiceFeature;
    class UniformFloat extends Internal.FloatProvider {
        static of($$0: number, $$1: number): Internal.UniformFloat;
        static readonly CODEC: Internal.Codec<Internal.UniformFloat>;
    }
    type UniformFloat_ = UniformFloat;
    class MatterCannonAmmo implements Internal.Recipe<net.minecraft.world.Container> {
        constructor(id: ResourceLocation_, ammo: Internal.Ingredient_, weight: number)
        getAmmo(): Internal.Ingredient;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        static ammo(consumer: Internal.Consumer_<Internal.FinishedRecipe>, id: ResourceLocation_, tag: Internal.TagKey_<Internal.Item>, weight: number): void;
        getWeight(): number;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(inv: net.minecraft.world.Container_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        static ammo(consumer: Internal.Consumer_<Internal.FinishedRecipe>, id: ResourceLocation_, ammo: Internal.Ingredient_, weight: number): void;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(inv: net.minecraft.world.Container_, level: Internal.Level_): boolean;
        static ammo(consumer: Internal.Consumer_<Internal.FinishedRecipe>, id: ResourceLocation_, item: Internal.ItemLike_, weight: number): void;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get ammo(): Internal.Ingredient
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get weight(): number
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        static readonly TYPE: Internal.RecipeType$1;
        static readonly TYPE_ID: ResourceLocation;
    }
    type MatterCannonAmmo_ = MatterCannonAmmo;
    interface IEntityAdditionalSpawnData {
        abstract writeSpawnData(arg0: Internal.FriendlyByteBuf_): void;
        abstract readSpawnData(arg0: Internal.FriendlyByteBuf_): void;
        readonly EXTRA_DATA_PACKET: ResourceLocation;
    }
    type IEntityAdditionalSpawnData_ = IEntityAdditionalSpawnData;
    interface IBlockState {
        abstract isCacheInvalid(): boolean;
        abstract clearCache(): void;
        get cacheInvalid(): boolean
    }
    type IBlockState_ = IBlockState;
    class Terminal {
        constructor(width: number, height: number, colour: boolean)
        constructor(width: number, height: number, colour: boolean, changedCallback: Internal.Runnable_)
        isColour(): boolean;
        getLine(y: number): Internal.TextBuffer;
        blit(text: Internal.ByteBuffer_, textColour: Internal.ByteBuffer_, backgroundColour: Internal.ByteBuffer_): void;
        setTextColour(colour: number): void;
        getPalette(): dan200.computercraft.core.terminal.Palette;
        setCursorBlink(blink: boolean): void;
        getBackgroundColourLine(y: number): Internal.TextBuffer;
        setChanged(): void;
        setCursorPos(x: number, y: number): void;
        reset(): void;
        getHeight(): number;
        getTextColourLine(y: number): Internal.TextBuffer;
        getBackgroundColour(): number;
        write(text: string): void;
        scroll(yDiff: number): void;
        getWidth(): number;
        getTextColour(): number;
        setLine(y: number, text: string, textColour: string, backgroundColour: string): void;
        static getColour(c: string, def: Internal.Colour_): number;
        setBackgroundColour(colour: number): void;
        getCursorBlink(): boolean;
        clear(): void;
        resize(width: number, height: number): void;
        clearLine(): void;
        getCursorX(): number;
        getCursorY(): number;
        get colour(): boolean
        set textColour(colour: number)
        get palette(): dan200.computercraft.core.terminal.Palette
        set cursorBlink(blink: boolean)
        get height(): number
        get backgroundColour(): number
        get width(): number
        get textColour(): number
        set backgroundColour(colour: number)
        get cursorBlink(): boolean
        get cursorX(): number
        get cursorY(): number
    }
    type Terminal_ = Terminal;
    class WeepingVinesPlantBlock extends Internal.GrowingPlantBodyBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly SHAPE: Internal.VoxelShapeSimpleCube;
    }
    type WeepingVinesPlantBlock_ = WeepingVinesPlantBlock;
    interface IBE <T extends Internal.BlockEntity> extends Internal.EntityBlock {
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<T>): void;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        abstract getBlockEntityClass(): T;
        abstract getBlockEntityType(): Internal.BlockEntityType<T>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<T, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): T;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<T>;
        get blockEntityClass(): T
        get blockEntityType(): Internal.BlockEntityType<T>
    }
    type IBE_<T extends Internal.BlockEntity> = IBE<T>;
    interface RegistryAccess$Frozen extends Internal.RegistryAccess {
        lookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.Optional<Internal.HolderLookup$RegistryLookup<T>>;
        allRegistriesLifecycle(): Internal.Lifecycle;
        create($$0: Internal.Stream_<Internal.HolderLookup$RegistryLookup<any>>): Internal.HolderLookup$Provider;
        abstract registry<E>(arg0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Optional<Internal.Registry<E>>;
        lookupOrThrow<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup$RegistryLookup<T>;
        registryOrThrow<E>($$0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Registry<E>;
        freeze(): this;
        abstract registries(): Internal.Stream<Internal.RegistryAccess$RegistryEntry<any>>;
        asGetterLookup(): Internal.HolderGetter$Provider;
        fromRegistryOfRegistries($$0: Internal.Registry_<Internal.Registry<any>>): this;
    }
    type RegistryAccess$Frozen_ = RegistryAccess$Frozen;
    class Positioning implements Internal.Animatable<Internal.Positioning> {
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        static absolute(xPixels: number, yPixels: number): Internal.Positioning;
        withY(y: number): this;
        static layout(): Internal.Positioning;
        static across(xPercent: number, yPercent: number): Internal.Positioning;
        static parse(positioningElement: Internal.Element_): Internal.Positioning;
        withX(x: number): this;
        isRelative(): boolean;
        interpolate(next: Internal.Positioning_, delta: number): this;
        static relative(xPercent: number, yPercent: number): Internal.Positioning;
        get relative(): boolean
        readonly type: Internal.Positioning$Type;
        readonly x: number;
        readonly y: number;
    }
    type Positioning_ = Positioning;
    class GameProfileCache {
        constructor($$0: Internal.GameProfileRepository_, $$1: Internal.File_)
        add($$0: Internal.GameProfile_): void;
        get($$0: string): Internal.Optional<Internal.GameProfile>;
        static setUsesAuthentication($$0: boolean): void;
        clearExecutor(): void;
        save(): void;
        get($$0: Internal.UUID_): Internal.Optional<Internal.GameProfile>;
        getAsync($$0: string, $$1: Internal.Consumer_<Internal.Optional<Internal.GameProfile>>): void;
        setExecutor($$0: Internal.Executor_): void;
        load(): Internal.List<Internal.GameProfileCache$GameProfileInfo>;
        set usesAuthentication($$0: boolean)
        set executor($$0: Internal.Executor_)
        readonly profilesByName: Internal.Map<string, Internal.GameProfileCache$GameProfileInfo>;
    }
    type GameProfileCache_ = GameProfileCache;
    abstract class Operator {
        constructor(arity: number, accepts: Internal.IotaMultiPredicate_)
        static downcast<T extends Internal.Iota>(iota: Internal.Iota_, iotaType: Internal.IotaType_<T>): T;
        abstract operate(arg0: Internal.CastingEnvironment_, arg1: Internal.CastingImage_, arg2: Internal.SpellContinuation_): Internal.OperationResult;
        readonly accepts: Internal.IotaMultiPredicate;
        readonly arity: number;
        static readonly Companion: Internal.Operator$Companion;
    }
    type Operator_ = Operator;
    class FrameForEach$Companion {
        constructor($constructor_marker: any_)
    }
    type FrameForEach$Companion_ = FrameForEach$Companion;
    class IllegalStateException extends Internal.RuntimeException {
        constructor()
        constructor(arg0: string, arg1: Internal.Throwable_)
        constructor(arg0: Internal.Throwable_)
        constructor(arg0: string)
    }
    type IllegalStateException_ = IllegalStateException;
    class OrderedCompoundTag extends Internal.CompoundTag {
        constructor()
        constructor(map: Internal.Map_<string, Internal.Tag>)
        getAsString(): string;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        putIfNotNull<T>(key: Internal.NbtKey_<T>, value: T): void;
        getOr<T>(key: Internal.NbtKey_<T>, defaultValue: T): T;
        copyIfPresent<T>(key: Internal.NbtKey_<T>, other: Internal.NbtCarrier_): void;
        copy<T>(key: Internal.NbtKey_<T>, other: Internal.NbtCarrier_): void;
        mutate<T>(key: Internal.NbtKey_<T>, mutator: Internal.Function_<T, T>): void;
        get asString(): string
        readonly tagMap: Internal.Map<string, Internal.Tag>;
    }
    type OrderedCompoundTag_ = OrderedCompoundTag;
    class RenderStateShard$OutputStateShard extends Internal.RenderStateShard {
        constructor($$0: string, $$1: Internal.Runnable_, $$2: Internal.Runnable_)
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
    }
    type RenderStateShard$OutputStateShard_ = RenderStateShard$OutputStateShard;
    class FuelTankMountedStorageType extends Internal.MountedFluidStorageType<Internal.FuelTankMountedStorage> {
        constructor()
        mount(level: Internal.Level_, state: Internal.BlockState_, pos: BlockPos_, be: Internal.BlockEntity_): Internal.FuelTankMountedStorage;
    }
    type FuelTankMountedStorageType_ = FuelTankMountedStorageType;
    interface ServerPlayerConnection {
        abstract send(arg0: Internal.Packet_<any>): void;
        abstract getPlayer(): Internal.ServerPlayer;
        get player(): Internal.ServerPlayer
    }
    type ServerPlayerConnection_ = ServerPlayerConnection;
    class SensorApp implements Internal.Ti69App {
        constructor()
        color(): number;
        renderTime(bufferSource: Internal.MultiBufferSource_, matrix4f: Matrix4f_, font: net.minecraft.client.gui.Font_, level: Internal.ClientLevel_): void;
        render(pose: Internal.PoseStack_, bufferSource: Internal.MultiBufferSource_, matrix4f: Matrix4f_, font: net.minecraft.client.gui.Font_, level: Internal.ClientLevel_, rightHanded: boolean): void;
        renderIcon(matrix4f: Matrix4f_, icon: ResourceLocation_, x: number, y: number, uOffset: number, vOffset: number, uWidth: number, vHeight: number, textureWidth: number, textureHeight: number): void;
        static readonly ID: ResourceLocation;
    }
    type SensorApp_ = SensorApp;
    interface IDisplayAssemblyExceptions {
        addExceptionToTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>): boolean;
        abstract getLastAssemblyException(): Internal.AssemblyException;
        get lastAssemblyException(): Internal.AssemblyException
        (): Internal.AssemblyException_;
    }
    type IDisplayAssemblyExceptions_ = IDisplayAssemblyExceptions;
    class ArrowDamageEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
    }
    type ArrowDamageEnchantment_ = ArrowDamageEnchantment;
    class CoralTreeFeature extends Internal.CoralFeature {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type CoralTreeFeature_ = CoralTreeFeature;
    class AlloyRecipe$Serializer extends Internal.LoggingRecipeSerializer<Internal.AlloyRecipe> {
        constructor()
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.AlloyRecipe;
    }
    type AlloyRecipe$Serializer_ = AlloyRecipe$Serializer;
    interface FabricResource {
        getFabricPackSource(): Internal.PackSource;
        get fabricPackSource(): Internal.PackSource
    }
    type FabricResource_ = FabricResource;
    class FlippersItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FlippersItem_ = FlippersItem;
    class Pair$Mu <S> implements Internal.K1 {
        constructor()
    }
    type Pair$Mu_<S> = Pair$Mu<S>;
    class DripstoneClusterConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: number, $$1: Internal.IntProvider_, $$2: Internal.IntProvider_, $$3: number, $$4: number, $$5: Internal.IntProvider_, $$6: Internal.FloatProvider_, $$7: Internal.FloatProvider_, $$8: number, $$9: number, $$10: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly heightDeviation: number;
        readonly maxDistanceFromCenterAffectingHeightBias: number;
        readonly maxStalagmiteStalactiteHeightDiff: number;
        readonly wetness: Internal.FloatProvider;
        readonly floorToCeilingSearchRange: number;
        readonly height: Internal.IntProvider;
        readonly maxDistanceFromEdgeAffectingChanceOfDripstoneColumn: number;
        readonly dripstoneBlockLayerThickness: Internal.IntProvider;
        readonly density: Internal.FloatProvider;
        readonly chanceOfDripstoneColumnAtMaxDistanceFromCenter: number;
        static readonly CODEC: Internal.Codec<Internal.DripstoneClusterConfiguration>;
        readonly radius: Internal.IntProvider;
    }
    type DripstoneClusterConfiguration_ = DripstoneClusterConfiguration;
    class Pointing extends Internal.Enum<Internal.Pointing> implements Internal.StringRepresentable {
        static valueOf(name: string): Internal.Pointing;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.Pointing[];
        getSerializedName(): string;
        getXRotation(): number;
        getCombinedDirection(direction: Internal.Direction_): Internal.Direction;
        get serializedName(): string
        get XRotation(): number
        static readonly RIGHT: Internal.Pointing;
        static readonly UP: Internal.Pointing;
        static readonly DOWN: Internal.Pointing;
        static readonly LEFT: Internal.Pointing;
    }
    type Pointing_ = Pointing | "up" | "down" | "right" | "left";
    abstract class TrackBufferBlock <BE extends Internal.TrackBufferBlockEntity> extends Internal.HorizontalDirectionalBlock implements Internal.ProperWaterloggedBlock, com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<BE> {
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        static getBaseModelYRotationOf(state: Internal.BlockState_, offset: number): number;
        setLightEmission(v: number): void;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        abstract getBlockEntityType(): Internal.BlockEntityType<BE>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<BE, Internal.InteractionResult>): Internal.InteractionResult;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        static getBaseModelYRotationOf(facing: Internal.Direction_): number;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<BE>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        static getBaseModelYRotationOf(facing: Internal.Direction_, offset: number): number;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        static getBaseModelYRotationOf(state: Internal.BlockState_): number;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<BE>): void;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        abstract getBlockEntityClass(): BE;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): BE;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<BE>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        get blockEntityClass(): BE
        static readonly DIAGONAL: Internal.BooleanProperty;
    }
    type TrackBufferBlock_<BE extends Internal.TrackBufferBlockEntity> = TrackBufferBlock<BE>;
    interface IPage {
        abstract setPage(arg0: number): void;
        abstract getPage(): number;
        set page(arg0: number)
        get page(): number
    }
    type IPage_ = IPage;
    class IGridNodeListener$State extends Internal.Enum<Internal.IGridNodeListener$State> {
        static valueOf(name: string): Internal.IGridNodeListener$State;
        static values(): Internal.IGridNodeListener$State[];
        static readonly CHANNEL: Internal.IGridNodeListener$State;
        static readonly GRID_BOOT: Internal.IGridNodeListener$State;
        static readonly POWER: Internal.IGridNodeListener$State;
    }
    type IGridNodeListener$State_ = IGridNodeListener$State | "power" | "channel" | "grid_boot";
    interface PotionItemEntityExtensions {
        abstract isMilk(): boolean;
        abstract setMilk(arg0: boolean): void;
        get milk(): boolean
        set milk(arg0: boolean)
    }
    type PotionItemEntityExtensions_ = PotionItemEntityExtensions;
    class BaseCoralPlantTypeBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type BaseCoralPlantTypeBlock_ = BaseCoralPlantTypeBlock;
    class ArmInteractionPoint {
        constructor(type: Internal.ArmInteractionPointType_, level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_)
        cycleMode(): void;
        isValid(): boolean;
        getTargetAngles(armPos: BlockPos_, ceiling: boolean): Internal.ArmAngleTarget;
        updateCachedState(): void;
        setLevel(level: Internal.Level_): void;
        static isInteractable(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getType(): Internal.ArmInteractionPointType;
        extract(amount: number, ctx: Internal.TransactionContext_): Internal.ItemStack;
        getLevel(): Internal.Level;
        getPos(): BlockPos;
        keepAlive(): void;
        static create(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): Internal.ArmInteractionPoint;
        getMode(): Internal.ArmInteractionPoint$Mode;
        extract(ctx: Internal.TransactionContext_): Internal.ItemStack;
        static transformPos(nbt: Internal.CompoundTag_, transform: Internal.StructureTransform_): void;
        insert(stack: Internal.ItemStack_, ctx: Internal.TransactionContext_): Internal.ItemStack;
        static deserialize(nbt: Internal.CompoundTag_, level: Internal.Level_, anchor: BlockPos_): Internal.ArmInteractionPoint;
        serialize(anchor: BlockPos_): Internal.CompoundTag;
        get valid(): boolean
        set level(level: Internal.Level_)
        get type(): Internal.ArmInteractionPointType
        get level(): Internal.Level
        get pos(): BlockPos
        get mode(): Internal.ArmInteractionPoint$Mode
    }
    type ArmInteractionPoint_ = ArmInteractionPoint;
    class HotbarManager {
        constructor($$0: Internal.File_, $$1: Internal.DataFixer_)
        get($$0: number): Internal.Hotbar;
        save(): void;
        static readonly NUM_HOTBAR_GROUPS: 9;
    }
    type HotbarManager_ = HotbarManager;
    class VillagerBabiesSensor extends Internal.Sensor<Internal.LivingEntity> {
        constructor()
    }
    type VillagerBabiesSensor_ = VillagerBabiesSensor;
    class MusicManager {
        constructor($$0: Internal.Minecraft_)
        startPlaying($$0: Internal.Music_): void;
        stopPlaying(): void;
        stopPlaying($$0: Internal.Music_): void;
        isPlayingMusic($$0: Internal.Music_): boolean;
        tick(): void;
    }
    type MusicManager_ = MusicManager;
    class RedStoneOreBlock extends Internal.Block implements Internal.CustomExpBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getExpDrop(state: Internal.BlockState_, world: Internal.LevelReader_, randomSource: Internal.RandomSource_, pos: BlockPos_, fortune: number, silktouch: number): number;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly LIT: Internal.BooleanProperty;
    }
    type RedStoneOreBlock_ = RedStoneOreBlock;
    class LootBuilder implements Internal.FunctionContainer, Internal.ConditionContainer {
        constructor(prev: Internal.JsonElement_)
        clearPools(): void;
        randomChanceWithLooting(chance: number, multiplier: number): Internal.ConditionContainer;
        name(name: net.minecraft.network.chat.Component_, entity: Internal.LootContext$EntityTarget_): Internal.FunctionContainer;
        toJson(): Internal.JsonObject;
        addPool(p: Internal.Consumer_<Internal.LootBuilderPool>): void;
        damage(damage: Internal.NumberProvider_): Internal.FunctionContainer;
        count(count: Internal.NumberProvider_): Internal.FunctionContainer;
        survivesExplosion(): Internal.ConditionContainer;
        addFunction(o: Internal.JsonObject_): this;
        clearConditions(): void;
        copyName(source: Internal.CopyNameFunction$NameSource_): Internal.FunctionContainer;
        addCondition(o: Internal.JsonObject_): this;
        lootTable(table: ResourceLocation_, seed: number): Internal.FunctionContainer;
        enchantWithLevels(levels: Internal.NumberProvider_, treasure: boolean): Internal.FunctionContainer;
        enchantRandomly(enchantments: ResourceLocation_[]): Internal.FunctionContainer;
        furnaceSmelt(): Internal.FunctionContainer;
        entityProperties(entity: Internal.LootContext$EntityTarget_, properties: Internal.JsonObject_): Internal.ConditionContainer;
        clearFunctions(): void;
        lootingEnchant(count: Internal.NumberProvider_, limit: number): Internal.FunctionContainer;
        addConditionalFunction(func: Internal.Consumer_<Internal.ConditionalFunction>): Internal.FunctionContainer;
        randomChance(chance: number): Internal.ConditionContainer;
        killedByPlayer(): Internal.ConditionContainer;
        nbt(tag: Internal.CompoundTag_): Internal.FunctionContainer;
        entityScores(entity: Internal.LootContext$EntityTarget_, scores: Internal.Map_<string, any>): Internal.ConditionContainer;
        name(name: net.minecraft.network.chat.Component_): Internal.FunctionContainer;
        type: string;
        conditions: Internal.JsonArray;
        pools: Internal.JsonArray;
        functions: Internal.JsonArray;
        customId: ResourceLocation;
    }
    type LootBuilder_ = LootBuilder;
    interface EntityTrackingSectionAccessor <T> {
        abstract getCollection(): Internal.ClassInstanceMultiMap<T>;
        get collection(): Internal.ClassInstanceMultiMap<T>
        (): Internal.ClassInstanceMultiMap_<T>;
    }
    type EntityTrackingSectionAccessor_<T> = EntityTrackingSectionAccessor<T>;
    class SafetyNetBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly WATERLOGGED: Internal.BooleanProperty;
    }
    type SafetyNetBlock_ = SafetyNetBlock;
    class CurrentFloorDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
    }
    type CurrentFloorDisplaySource_ = CurrentFloorDisplaySource;
    class ReportEnvironment extends Internal.Record {
        constructor($$0: string, $$1: Internal.ReportEnvironment$Server_)
        server(): Internal.ReportEnvironment$Server;
        clientVersion(): string;
        static local(): Internal.ReportEnvironment;
        static realm($$0: Internal.RealmsServer_): Internal.ReportEnvironment;
        thirdPartyServerInfo(): Internal.AbuseReportRequest$ThirdPartyServerInfo;
        static thirdParty($$0: string): Internal.ReportEnvironment;
        clientInfo(): Internal.AbuseReportRequest$ClientInfo;
        static create($$0: Internal.ReportEnvironment$Server_): Internal.ReportEnvironment;
        realmInfo(): Internal.AbuseReportRequest$RealmInfo;
    }
    type ReportEnvironment_ = ReportEnvironment;
    class WorldCreationContext extends Internal.Record {
        constructor($$0: any_, $$1: Internal.LayeredRegistryAccess_<Internal.RegistryLayer>, $$2: Internal.ReloadableServerResources_, $$3: Internal.WorldDataConfiguration_)
        constructor($$0: Internal.WorldOptions_, $$1: Internal.Registry_<Internal.LevelStem>, $$2: Internal.WorldDimensions_, $$3: Internal.LayeredRegistryAccess_<Internal.RegistryLayer>, $$4: Internal.ReloadableServerResources_, $$5: Internal.WorldDataConfiguration_)
        constructor($$0: Internal.WorldOptions_, $$1: Internal.WorldDimensions_, $$2: Internal.LayeredRegistryAccess_<Internal.RegistryLayer>, $$3: Internal.ReloadableServerResources_, $$4: Internal.WorldDataConfiguration_)
        worldgenRegistries(): Internal.LayeredRegistryAccess<Internal.RegistryLayer>;
        dataConfiguration(): Internal.WorldDataConfiguration;
        dataPackResources(): Internal.ReloadableServerResources;
        options(): Internal.WorldOptions;
        datapackDimensions(): Internal.Registry<Internal.LevelStem>;
        withDimensions($$0: Internal.WorldCreationContext$DimensionsUpdater_): this;
        withSettings($$0: Internal.WorldOptions_, $$1: Internal.WorldDimensions_): this;
        withOptions($$0: Internal.WorldCreationContext$OptionsModifier_): this;
        worldgenLoadContext(): Internal.RegistryAccess$Frozen;
        selectedDimensions(): Internal.WorldDimensions;
    }
    type WorldCreationContext_ = WorldCreationContext;
    class StonecutterMenu extends Internal.AbstractContainerMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: any_)
        constructor($$0: number, $$1: Internal.Inventory_)
        getRecipes(): Internal.List<Internal.StonecutterRecipe>;
        getSelectedRecipeIndex(): number;
        hasInputItem(): boolean;
        getNumRecipes(): number;
        registerUpdateListener($$0: Internal.Runnable_): void;
        get recipes(): Internal.List<Internal.StonecutterRecipe>
        get selectedRecipeIndex(): number
        get numRecipes(): number
        static readonly INPUT_SLOT: 0;
        static readonly RESULT_SLOT: 1;
        readonly container: net.minecraft.world.Container;
    }
    type StonecutterMenu_ = StonecutterMenu;
    interface ServerPlayerLanguageAccessor {
        abstract rightclickharvest$getLanguage(): string;
        (): string;
    }
    type ServerPlayerLanguageAccessor_ = ServerPlayerLanguageAccessor;
    class OwoUIDrawContext$TextAnchor extends Internal.Enum<Internal.OwoUIDrawContext$TextAnchor> {
        static values(): Internal.OwoUIDrawContext$TextAnchor[];
        static valueOf(name: string): Internal.OwoUIDrawContext$TextAnchor;
        static readonly TOP_LEFT: Internal.OwoUIDrawContext$TextAnchor;
        static readonly BOTTOM_RIGHT: Internal.OwoUIDrawContext$TextAnchor;
        static readonly BOTTOM_LEFT: Internal.OwoUIDrawContext$TextAnchor;
        static readonly TOP_RIGHT: Internal.OwoUIDrawContext$TextAnchor;
    }
    type OwoUIDrawContext$TextAnchor_ = "bottom_right" | "top_left" | "top_right" | OwoUIDrawContext$TextAnchor | "bottom_left";
    class LargeDripstoneFeature extends Internal.Feature<Internal.LargeDripstoneConfiguration> {
        constructor($$0: Internal.Codec_<Internal.LargeDripstoneConfiguration>)
    }
    type LargeDripstoneFeature_ = LargeDripstoneFeature;
    interface ScreenMouseEvents$AfterMouseRelease {
        abstract afterMouseRelease(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): void;
        (arg0: Internal.Screen, arg1: number, arg2: number, arg3: number): void;
    }
    type ScreenMouseEvents$AfterMouseRelease_ = ScreenMouseEvents$AfterMouseRelease;
    class CompositeByteBuf extends Internal.AbstractReferenceCountedByteBuf implements Internal.Iterable<Internal.ByteBuf> {
        constructor(arg0: Internal.ByteBufAllocator_, arg1: boolean, arg2: number, ...arg3: Internal.ByteBuf_[])
        constructor(arg0: Internal.ByteBufAllocator_, arg1: boolean, arg2: number, arg3: Internal.Iterable_<Internal.ByteBuf>)
        constructor(arg0: Internal.ByteBufAllocator_, arg1: boolean, arg2: number)
        resetWriterIndex(): this;
        resetReaderIndex(): this;
        writeByte(arg0: number): this;
        addComponent(arg0: boolean, arg1: Internal.ByteBuf_): this;
        writeBytes(arg0: number[], arg1: number, arg2: number): this;
        componentAtOffset(arg0: number): Internal.ByteBuf;
        addComponents(arg0: boolean, ...arg1: Internal.ByteBuf_[]): this;
        readBytes(arg0: Internal.ByteBuf_, arg1: number): this;
        writeBytes(arg0: Internal.ByteBuffer_): this;
        writeLong(arg0: number): this;
        toComponentIndex(arg0: number): number;
        getBytes(arg0: number, arg1: number[]): this;
        writeShort(arg0: number): this;
        removeComponent(arg0: number): this;
        setByte(arg0: number, arg1: number): this;
        internalComponentAtOffset(arg0: number): Internal.ByteBuf;
        getBytes(arg0: number, arg1: Internal.OutputStream_, arg2: number): this;
        readBytes(arg0: number[]): this;
        maxNumComponents(): number;
        retain(arg0: number): Internal.ReferenceCounted;
        writeMedium(arg0: number): this;
        skipBytes(arg0: number): this;
        touch(arg0: any): Internal.ReferenceCounted;
        touch(): this;
        component(arg0: number): Internal.ByteBuf;
        setChar(arg0: number, arg1: number): this;
        numComponents(): number;
        addComponent(arg0: boolean, arg1: number, arg2: Internal.ByteBuf_): this;
        addComponents(arg0: number, arg1: Internal.Iterable_<Internal.ByteBuf>): this;
        consolidate(arg0: number, arg1: number): this;
        iterator(): Internal.Iterator<Internal.ByteBuf>;
        decompose(arg0: number, arg1: number): Internal.List<Internal.ByteBuf>;
        discardSomeReadBytes(): this;
        addComponent(arg0: number, arg1: Internal.ByteBuf_): this;
        ensureWritable(arg0: number): this;
        spliterator(): Internal.Spliterator<Internal.ByteBuf>;
        clear(): this;
        addComponents(arg0: Internal.Iterable_<Internal.ByteBuf>): this;
        readBytes(arg0: Internal.ByteBuf_): this;
        internalComponent(arg0: number): Internal.ByteBuf;
        addComponents(...arg0: Internal.ByteBuf_[]): this;
        setBoolean(arg0: number, arg1: boolean): this;
        setZero(arg0: number, arg1: number): this;
        addComponent(arg0: Internal.ByteBuf_): this;
        removeComponents(arg0: number, arg1: number): this;
        getBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number): this;
        setBytes(arg0: number, arg1: Internal.ByteBuf_): this;
        writeDouble(arg0: number): this;
        addComponents(arg0: number, ...arg1: Internal.ByteBuf_[]): this;
        setBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number, arg3: number): this;
        getBytes(arg0: number, arg1: Internal.ByteBuf_): this;
        addComponents(arg0: boolean, arg1: Internal.Iterable_<Internal.ByteBuf>): this;
        discardReadComponents(): this;
        setBytes(arg0: number, arg1: Internal.ByteBuffer_): this;
        addFlattenedComponents(arg0: boolean, arg1: Internal.ByteBuf_): this;
        capacity(arg0: number): this;
        getBytes(arg0: number, arg1: Internal.ByteBuffer_): this;
        setBytes(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        consolidate(): this;
        getBytes(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        setBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number): this;
        retain(): Internal.ReferenceCounted;
        readBytes(arg0: number[], arg1: number, arg2: number): this;
        forEach(arg0: Internal.Consumer_<Internal.ByteBuf>): void;
        discardReadBytes(): this;
        toByteIndex(arg0: number): number;
        getBytes(arg0: number, arg1: Internal.ByteBuf_, arg2: number, arg3: number): this;
    }
    type CompositeByteBuf_ = CompositeByteBuf;
    class BlockGhostChest extends Internal.ChestBlock {
        constructor()
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockGhostChest_ = BlockGhostChest;
    class DynamicLightBehavior$BoundingBox extends Internal.Record {
        constructor(startX: number, startY: number, startZ: number, endX: number, endY: number, endZ: number)
        endX(): number;
        endY(): number;
        endZ(): number;
        startZ(): number;
        startX(): number;
        startY(): number;
    }
    type DynamicLightBehavior$BoundingBox_ = DynamicLightBehavior$BoundingBox;
    interface IPlantable {
        getPlant(world: Internal.BlockGetter_, pos: BlockPos_): Internal.BlockState;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
    }
    type IPlantable_ = IPlantable;
    class AttributeFilterItem extends Internal.FilterItem {
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        canCopyFromItem(item: Internal.ItemStack_): boolean;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        shouldCloseCurrentScreen(): boolean;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        canCopyToItem(item: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        createCopy(original: Internal.ItemStack_, count: number): Internal.ItemStack;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AttributeFilterItem_ = AttributeFilterItem;
    interface UnmodifiableConfig {
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        getOrElse<T>(arg0: string, arg1: T): T;
        getLong(arg0: string): number;
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getInt(arg0: Internal.List_<string>): number;
        getByteOrElse(arg0: string, arg1: number): number;
        getShortOrElse(arg0: string, arg1: number): number;
        get<T>(arg0: Internal.List_<string>): T;
        getCharOrElse(arg0: string, arg1: string): string;
        contains(arg0: string): boolean;
        getShort(arg0: Internal.List_<string>): number;
        getShortOrElse(arg0: Internal.List_<string>, arg1: number): number;
        isNull(arg0: Internal.List_<string>): boolean;
        getIntOrElse(arg0: Internal.List_<string>, arg1: number): number;
        abstract getRaw<T>(arg0: Internal.List_<string>): T;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: Internal.Supplier_<T>): T;
        getOptionalLong(arg0: string): Internal.OptionalLong;
        getOptional<T>(arg0: Internal.List_<string>): Internal.Optional<T>;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        getOptional<T>(arg0: string): Internal.Optional<T>;
        getShort(arg0: string): number;
        getOrElse<T>(arg0: string, arg1: Internal.Supplier_<T>): T;
        abstract entrySet(): Internal.Set<Internal.UnmodifiableConfig$Entry>;
        getChar(arg0: string): string;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: T): T;
        getOptionalLong(arg0: Internal.List_<string>): Internal.OptionalLong;
        getChar(arg0: Internal.List_<string>): string;
        get<T>(arg0: string): T;
        abstract contains(arg0: Internal.List_<string>): boolean;
        getLong(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        apply<T>(arg0: Internal.List_<string>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: Internal.LongSupplier_): number;
        getInt(arg0: string): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: number): number;
        isEmpty(): boolean;
        getIntOrElse(arg0: Internal.List_<string>, arg1: Internal.IntSupplier_): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        getRaw<T>(arg0: string): T;
        getIntOrElse(arg0: string, arg1: Internal.IntSupplier_): number;
        isNull(arg0: string): boolean;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): Internal.Optional<T>;
        getCharOrElse(arg0: Internal.List_<string>, arg1: string): string;
        getByte(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): Internal.Optional<T>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        getByteOrElse(arg0: Internal.List_<string>, arg1: number): number;
        getLongOrElse(arg0: string, arg1: number): number;
        getOptionalInt(arg0: string): Internal.OptionalInt;
        getLongOrElse(arg0: string, arg1: Internal.LongSupplier_): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: Internal.Supplier_<T>): T;
        getByte(arg0: string): number;
        getIntOrElse(arg0: string, arg1: number): number;
        getOptionalInt(arg0: Internal.List_<string>): Internal.OptionalInt;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        abstract configFormat(): Internal.ConfigFormat<any>;
        abstract size(): number;
        /**
         * @deprecated
        */
        abstract valueMap(): Internal.Map<string, any>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: Internal.Supplier_<T>): T;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        apply<T>(arg0: string): T;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        get empty(): boolean
    }
    type UnmodifiableConfig_ = UnmodifiableConfig;
    abstract class CookingUpgradeWrapper <W extends Internal.CookingUpgradeWrapper<W, U, R>, U extends Internal.UpgradeItemBase<W> & Internal.ICookingUpgradeItem, R extends Internal.AbstractCookingRecipe> extends Internal.UpgradeWrapperBase<W, U> implements Internal.ICookingUpgrade<R>, Internal.ITickableUpgrade {
        canBeDisabled(): boolean;
        hideSettingsTab(): boolean;
        tick(entity: Internal.Entity_, world: Internal.Level_, pos: BlockPos_): void;
        getCookingLogic(): Internal.CookingLogic<R>;
        onAdded(): void;
        get cookingLogic(): Internal.CookingLogic<R>
    }
    type CookingUpgradeWrapper_<W extends Internal.CookingUpgradeWrapper<W, U, R>, U extends Internal.UpgradeItemBase<W> & Internal.ICookingUpgradeItem, R extends Internal.AbstractCookingRecipe> = CookingUpgradeWrapper<W, U, R>;
    class RandomSelectorFeature extends Internal.Feature<Internal.RandomFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.RandomFeatureConfiguration>)
    }
    type RandomSelectorFeature_ = RandomSelectorFeature;
    class CookingUpgradeWrapper$BlastingUpgradeWrapper extends Internal.CookingUpgradeWrapper<Internal.CookingUpgradeWrapper$BlastingUpgradeWrapper, Internal.BlastingUpgradeItem, Internal.BlastingRecipe> {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        canBeDisabled(): boolean;
        hideSettingsTab(): boolean;
        onAdded(): void;
    }
    type CookingUpgradeWrapper$BlastingUpgradeWrapper_ = CookingUpgradeWrapper$BlastingUpgradeWrapper;
    interface AxeItemAccessor {
        abstract porting_lib$getStripped(arg0: Internal.BlockState_): Internal.Optional<Internal.BlockState>;
        (arg0: Internal.BlockState): Internal.Optional_<Internal.BlockState>;
    }
    type AxeItemAccessor_ = AxeItemAccessor;
    interface Command <S> {
        abstract run(arg0: Internal.CommandContext_<S>): number;
        (arg0: Internal.CommandContext<S>): number;
        readonly SINGLE_SUCCESS: 1;
    }
    type Command_<S> = Command<S>;
    class AutoCookingUpgradeWrapper$AutoSmokingUpgradeWrapper extends Internal.AutoCookingUpgradeWrapper<Internal.AutoCookingUpgradeWrapper$AutoSmokingUpgradeWrapper, Internal.AutoSmokingUpgradeItem, Internal.SmokingRecipe> {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        canBeDisabled(): boolean;
        hideSettingsTab(): boolean;
        onAdded(): void;
    }
    type AutoCookingUpgradeWrapper$AutoSmokingUpgradeWrapper_ = AutoCookingUpgradeWrapper$AutoSmokingUpgradeWrapper;
    interface ScreenMouseEvents$AllowMouseRelease {
        abstract allowMouseRelease(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): boolean;
        (arg0: Internal.Screen, arg1: number, arg2: number, arg3: number): boolean;
    }
    type ScreenMouseEvents$AllowMouseRelease_ = ScreenMouseEvents$AllowMouseRelease;
    interface LiquidBlockContainer {
        abstract canPlaceLiquid(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Fluid_): boolean;
        abstract placeLiquid(arg0: Internal.LevelAccessor_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.FluidState_): boolean;
    }
    type LiquidBlockContainer_ = LiquidBlockContainer;
    class WritingMode extends Internal.Enum<Internal.WritingMode> {
        static values(): Internal.WritingMode[];
        static valueOf(arg0: string): Internal.WritingMode;
        static readonly REPLACE: Internal.WritingMode;
        static readonly APPEND: Internal.WritingMode;
        static readonly REPLACE_ATOMIC: Internal.WritingMode;
    }
    type WritingMode_ = "replace" | WritingMode | "append" | "replace_atomic";
    class QuartzWrenchItem extends Internal.AEBaseItem {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type QuartzWrenchItem_ = QuartzWrenchItem;
    class HashMap <K, V> extends Internal.AbstractMap<K, V> implements Internal.Cloneable, Internal.Map<K, V>, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.Map_<K, V>)
        constructor(arg0: number)
        constructor(arg0: number, arg1: number)
        clone(): any;
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        replace(arg0: K, arg1: V): V;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        put(arg0: K, arg1: V): V;
        get(arg0: any): V;
        remove(arg0: any): V;
        static copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        putIfAbsent(arg0: K, arg1: V): V;
        keySet(): Internal.Set<K>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        values(): Internal.Collection<V>;
        entrySet(): Internal.Set<Internal.Map$Entry<K, V>>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        static newHashMap<K, V>(arg0: number): Internal.HashMap<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        static ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        static of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
    }
    type HashMap_<K, V> = HashMap<K, V>;
    class RedStoneWireBlock extends Internal.Block implements Internal.IMixinRedstoneWireBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        litematicaGetPlacementState(arg0: Internal.BlockGetter_, arg1: Internal.BlockState_, arg2: BlockPos_): Internal.BlockState;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        static getColorForPower($$0: number): number;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly WEST: Internal.EnumProperty<Internal.RedstoneSide>;
        static readonly PROPERTY_BY_DIRECTION: {[key: Internal.Direction]: Internal.EnumProperty<any>, [key: Internal.Direction]: Internal.EnumProperty<any>, [key: Internal.Direction]: Internal.EnumProperty<any>, [key: Internal.Direction]: Internal.EnumProperty<any>};
        static readonly NORTH: Internal.EnumProperty<Internal.RedstoneSide>;
        static readonly SOUTH: Internal.EnumProperty<Internal.RedstoneSide>;
        static readonly EAST: Internal.EnumProperty<Internal.RedstoneSide>;
        static readonly POWER: Internal.IntegerProperty;
    }
    type RedStoneWireBlock_ = RedStoneWireBlock;
    class QuickChargeEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
    }
    type QuickChargeEnchantment_ = QuickChargeEnchantment;
    interface Multimap <K, V> {
        abstract keySet(): Internal.Set<K>;
        abstract replaceValues(arg0: K, arg1: Internal.Iterable_<V>): Internal.Collection<V>;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        abstract get(arg0: K): Internal.Collection<V>;
        abstract removeAll(arg0: any): Internal.Collection<V>;
        abstract entries(): Internal.Collection<Internal.Map$Entry<K, V>>;
        abstract values(): Internal.Collection<V>;
        abstract containsValue(arg0: any): boolean;
        abstract remove(arg0: any, arg1: any): boolean;
        abstract isEmpty(): boolean;
        abstract containsEntry(arg0: any, arg1: any): boolean;
        abstract size(): number;
        abstract hashCode(): number;
        abstract containsKey(arg0: any): boolean;
        abstract putAll(arg0: Internal.Multimap_<K, V>): boolean;
        abstract put(arg0: K, arg1: V): boolean;
        abstract clear(): void;
        abstract putAll(arg0: K, arg1: Internal.Iterable_<V>): boolean;
        abstract equals(arg0: any): boolean;
        abstract keys(): Internal.Multiset<K>;
        abstract asMap(): Internal.Map<K, Internal.Collection<V>>;
        get empty(): boolean
    }
    type Multimap_<K, V> = Multimap<K, V>;
    interface ContainerEventHandler extends Internal.GuiEventListener {
        charTyped($$0: string, $$1: number): boolean;
        isFocused(): boolean;
        magicalSpecialHackyFocus($$0: Internal.GuiEventListener_): void;
        redirect$hma000$yet_another_config_lib_v3$modifyFocusCandidates(instance: Internal.ContainerEventHandler_, screenArea: Internal.ScreenRectangle_, direction: Internal.ScreenDirection_, focused: Internal.GuiEventListener_, event: Internal.FocusNavigationEvent_): Internal.List<any>;
        setFocused($$0: boolean): void;
        mouseReleased($$0: number, $$1: number, $$2: number): boolean;
        getTabOrderGroup(): number;
        mouseScrolled($$0: number, $$1: number, $$2: number): boolean;
        keyReleased($$0: number, $$1: number, $$2: number): boolean;
        abstract setFocused(arg0: Internal.GuiEventListener_): void;
        mouseClicked($$0: number, $$1: number, $$2: number): boolean;
        keyPressed($$0: number, $$1: number, $$2: number): boolean;
        abstract setDragging(arg0: boolean): void;
        getCurrentFocusPath(): Internal.ComponentPath;
        abstract children(): Internal.List<Internal.GuiEventListener>;
        mouseDragged($$0: number, $$1: number, $$2: number, $$3: number, $$4: number): boolean;
        getChildAt($$0: number, $$1: number): Internal.Optional<Internal.GuiEventListener>;
        abstract isDragging(): boolean;
        mouseMoved($$0: number, $$1: number): void;
        getRectangle(): Internal.ScreenRectangle;
        abstract getFocused(): Internal.GuiEventListener;
        isMouseOver($$0: number, $$1: number): boolean;
        nextFocusPath($$0: Internal.FocusNavigationEvent_): Internal.ComponentPath;
        get focused(): boolean
        set focused($$0: boolean)
        get tabOrderGroup(): number
        set focused(arg0: Internal.GuiEventListener_)
        set dragging(arg0: boolean)
        get currentFocusPath(): Internal.ComponentPath
        get dragging(): boolean
        get rectangle(): Internal.ScreenRectangle
        get focused(): Internal.GuiEventListener
    }
    type ContainerEventHandler_ = ContainerEventHandler;
    class EvaluatorException extends Internal.RhinoException {
        constructor(cx: Internal.Context_, detail: string, sourceName: string, lineNumber: number, lineSource: string, columnNumber: number)
        constructor(cx: Internal.Context_, detail: string, sourceName: string, lineNumber: number)
        constructor(cx: Internal.Context_, detail: string)
    }
    type EvaluatorException_ = EvaluatorException;
    class ComparatorBlockEntity extends Internal.BlockEntity {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        setOutputSignal($$0: number): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getOutputSignal(): number;
        set outputSignal($$0: number)
        get outputSignal(): number
    }
    type ComparatorBlockEntity_ = ComparatorBlockEntity;
    class TallFlowerBlock extends Internal.DoublePlantBlock implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type TallFlowerBlock_ = TallFlowerBlock;
    class FluixSmithingTemplateItem extends Internal.SmithingTemplateItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type FluixSmithingTemplateItem_ = FluixSmithingTemplateItem;
    interface PlayerKJS extends Internal.DataSenderKJS, Internal.WithAttachedData<Internal.Player>, Internal.LivingEntityKJS {
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        setY(y: number): void;
        getXpLevel(): number;
        setSelectedSlot(index: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        paint(renderer: Internal.CompoundTag_): void;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        getFoodLevel(): number;
        notify(title: net.minecraft.network.chat.Component_, text: net.minecraft.network.chat.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        getCraftingGrid(): Internal.InventoryKJS;
        setXpLevel(l: number): void;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        addXPLevels(l: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPersistentData(): Internal.CompoundTag;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        setX(x: number): void;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        self(): Internal.LivingEntity;
        setXp(xp: number): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        isAmbientCreature(): boolean;
        getInventoryChangeListener(): Internal.KubeJSInventoryListener;
        notify(builder: Notification_): void;
        isMonster(): boolean;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getStages(): Internal.Stages;
        getName(): net.minecraft.network.chat.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        getInventory(): Internal.InventoryKJS;
        give(item: Internal.ItemStack_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        sendInventoryUpdate(): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        abstract getData(): Internal.AttachedData<Internal.Player>;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get craftingGrid(): Internal.InventoryKJS
        set xpLevel(l: number)
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get persistentData(): Internal.CompoundTag
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get ambientCreature(): boolean
        get inventoryChangeListener(): Internal.KubeJSInventoryListener
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get stages(): Internal.Stages
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get inventory(): Internal.InventoryKJS
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get data(): Internal.AttachedData<Internal.Player>
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
        (): Internal.AttachedData_<Internal.Player>;
    }
    type PlayerKJS_ = PlayerKJS;
    class PropertyParam extends Internal.AbstractProperty<Internal.PropertyParam> {
        constructor()
        constructor(name: string, type: Internal.PropertyType_<any>, isVarArg: boolean)
        isVarArg(): boolean;
        getType(): Internal.PropertyType<any>;
        copy(): Internal.AbstractDocumentBase<any>;
        getName(): string;
        static fromJava(info: Internal.MethodInfo$ParamInfo_): Internal.PropertyParam;
        get varArg(): boolean
        get type(): Internal.PropertyType<any>
        get name(): string
    }
    type PropertyParam_ = PropertyParam;
    interface DirectBeltInputBehaviour$AvailabilityPredicate {
        abstract test(arg0: Internal.Direction_): boolean;
        (arg0: Internal.Direction): boolean;
    }
    type DirectBeltInputBehaviour$AvailabilityPredicate_ = DirectBeltInputBehaviour$AvailabilityPredicate;
    abstract class AbstractLayout <L extends Internal.AbstractLayout<L> & Internal.MemoryLayout> {
        withoutName(): L;
        hasNaturalAlignment(): boolean;
        name(): Internal.Optional<string>;
        byteAlignment(): number;
        withName(arg0: string): L;
        withByteAlignment(arg0: number): L;
        byteSize(): number;
    }
    type AbstractLayout_<L extends Internal.AbstractLayout<L> & Internal.MemoryLayout> = AbstractLayout<L>;
    interface PositionedEntityTrackingSection {
        abstract setPos(arg0: number): void;
        abstract getPos(): number;
        set pos(arg0: number)
        get pos(): number
    }
    type PositionedEntityTrackingSection_ = PositionedEntityTrackingSection;
    interface IDragonFlute {
        abstract onHearFlute(arg0: Internal.Player_): void;
        (arg0: Internal.Player): void;
    }
    type IDragonFlute_ = IDragonFlute;
    class HexDir extends Internal.Enum<Internal.HexDir> {
        times(a: Internal.HexAngle_): this;
        static fromString(key: string): Internal.HexDir;
        angleFrom(other: Internal.HexDir_): Internal.HexAngle;
        static valueOf(value: string): Internal.HexDir;
        asDelta(): Internal.HexCoord;
        static access$getCODEC$cp(): Internal.Codec<any>;
        rotatedBy(a: Internal.HexAngle_): this;
        minus(other: Internal.HexDir_): Internal.HexAngle;
        static values(): Internal.HexDir[];
        static readonly SOUTH_WEST: Internal.HexDir;
        static readonly Companion: Internal.HexDir$Companion;
        static readonly SOUTH_EAST: Internal.HexDir;
        static readonly NORTH_WEST: Internal.HexDir;
        static readonly NORTH_EAST: Internal.HexDir;
        static readonly WEST: Internal.HexDir;
        static readonly EAST: Internal.HexDir;
    }
    type HexDir_ = "north_west" | "west" | HexDir | "north_east" | "east" | "south_west" | "south_east";
    class UserType extends Internal.Enum<Internal.UserType> {
        static values(): Internal.UserType[];
        static byName(arg0: string): Internal.UserType;
        getName(): string;
        static valueOf(arg0: string): Internal.UserType;
        get name(): string
        static readonly MOJANG: Internal.UserType;
        static readonly LEGACY: Internal.UserType;
    }
    type UserType_ = "mojang" | "legacy" | UserType;
    /**
     * Invoked when the debug info is rendered.
    */
    class DebugInfoEventJS extends Internal.ClientEventJS {
        constructor(l: Internal.List_<string>)
        getEntity(): Internal.Entity;
        /**
         * The lines of debug info. Mutating this list will change the debug info.
        */
        getLines(): Internal.List<string>;
        /**
         * Whether the debug info should be rendered.
        */
        getShowDebug(): boolean;
        get entity(): Internal.Entity
        /**
         * The lines of debug info. Mutating this list will change the debug info.
        */
        get lines(): Internal.List<string>
        /**
         * Whether the debug info should be rendered.
        */
        get showDebug(): boolean
    }
    type DebugInfoEventJS_ = DebugInfoEventJS;
    class ChestMountedStorageType extends Internal.SimpleMountedStorageType<any> {
        constructor()
        mount(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: BlockPos_, arg3: Internal.BlockEntity_): Internal.MountedItemStorage;
    }
    type ChestMountedStorageType_ = ChestMountedStorageType;
    class WallTorchBlock extends Internal.TorchBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_, $$1: Internal.ParticleOptions_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        static getShape($$0: Internal.BlockState_): Internal.VoxelShape;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly FACING: Internal.DirectionProperty;
    }
    type WallTorchBlock_ = WallTorchBlock;
    class ServerboundContainerClosePacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getContainerId(): number;
        isSkippable(): boolean;
        get containerId(): number
        get skippable(): boolean
    }
    type ServerboundContainerClosePacket_ = ServerboundContainerClosePacket;
    class SpoutBlockEntity extends Internal.SmartBlockEntity implements Internal.IHaveGoggleInformation, Internal.SidedStorageBlockEntity, Internal.CustomRenderBoundingBoxBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getFluidStorage(face: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getItemStorage(side: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        customProcess: Internal.BlockSpoutingBehaviour;
        static readonly FILLING_TIME: 20;
        sendSplash: boolean;
        processingTicks: number;
    }
    type SpoutBlockEntity_ = SpoutBlockEntity;
    interface TypeWrapperFactory <T> {
        abstract wrap(arg0: Internal.Context_, arg1: any): T;
        (arg0: Internal.Context, arg1: any): T;
    }
    type TypeWrapperFactory_<T> = TypeWrapperFactory<T>;
    interface MouseLeave {
        newStream(): Internal.EventStream<Internal.MouseLeave>;
        abstract onMouseLeave(): void;
        (): void;
    }
    type MouseLeave_ = MouseLeave;
    abstract class NumericTag implements Internal.Tag, Internal.SpecialEquality {
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        specialEquals(o: any, shallow: boolean): boolean;
        abstract getAsDouble(): number;
        abstract accept(arg0: Internal.TagVisitor_): void;
        abstract sizeInBytes(): number;
        abstract getAsLong(): number;
        abstract getAsFloat(): number;
        abstract getAsInt(): number;
        getAsString(): string;
        abstract getType(): Internal.TagType<any>;
        abstract getAsByte(): number;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        abstract getAsNumber(): number;
        abstract copy(): Internal.Tag;
        abstract write(arg0: Internal.DataOutput_): void;
        abstract getId(): number;
        abstract getAsShort(): number;
        abstract accept(arg0: Internal.StreamTagVisitor_): Internal.StreamTagVisitor$ValueResult;
        get asDouble(): number
        get asLong(): number
        get asFloat(): number
        get asInt(): number
        get asString(): string
        get type(): Internal.TagType<any>
        get asByte(): number
        get asNumber(): number
        get id(): number
        get asShort(): number
    }
    type NumericTag_ = NumericTag;
    class ServerPlayerGameMode {
        constructor($$0: Internal.ServerPlayer_)
        handler$gfh000$porting_lib_entity$port_lib$blockBreak(pos: BlockPos_, action: Internal.ServerboundPlayerActionPacket$Action_, direction: Internal.Direction_, worldHeight: number, i: number, ci: Internal.CallbackInfo_): void;
        getGameModeForPlayer(): Internal.GameType;
        handler$zdo000$porting_lib_base$port_lib$destroyBlock(pos: BlockPos_, cir: Internal.CallbackInfoReturnable_<any>): void;
        handler$zdo000$porting_lib_base$port_lib$onItemFirstUse(player: Internal.ServerPlayer_, level: Internal.Level_, stack: Internal.ItemStack_, hand: Internal.InteractionHand_, hit: Internal.BlockHitResult_, cir: Internal.CallbackInfoReturnable_<any>): void;
        useItemOn($$0: Internal.ServerPlayer_, $$1: Internal.Level_, $$2: Internal.ItemStack_, $$3: Internal.InteractionHand_, $$4: Internal.BlockHitResult_): Internal.InteractionResult;
        "handler$cee000$fabric-events-interaction-v0$startBlockBreak"(pos: BlockPos_, playerAction: Internal.ServerboundPlayerActionPacket$Action_, direction: Internal.Direction_, worldHeight: number, i: number, info: Internal.CallbackInfo_): void;
        getPreviousGameModeForPlayer(): Internal.GameType;
        isSurvival(): boolean;
        changeGameModeForPlayer($$0: Internal.GameType_): boolean;
        handleBlockBreakAction($$0: BlockPos_, $$1: Internal.ServerboundPlayerActionPacket$Action_, $$2: Internal.Direction_, $$3: number, $$4: number): void;
        destroyAndAck($$0: BlockPos_, $$1: number, $$2: string): void;
        "handler$cee000$fabric-events-interaction-v0$interactItem"(player: Internal.ServerPlayer_, world: Internal.Level_, stack: Internal.ItemStack_, hand: Internal.InteractionHand_, info: Internal.CallbackInfoReturnable_<any>): void;
        tick(): void;
        setLevel($$0: Internal.ServerLevel_): void;
        isCreative(): boolean;
        "handler$cee000$fabric-events-interaction-v0$interactBlock"(player: Internal.ServerPlayer_, world: Internal.Level_, stack: Internal.ItemStack_, hand: Internal.InteractionHand_, blockHitResult: Internal.BlockHitResult_, info: Internal.CallbackInfoReturnable_<any>): void;
        destroyBlock($$0: BlockPos_): boolean;
        useItem($$0: Internal.ServerPlayer_, $$1: Internal.Level_, $$2: Internal.ItemStack_, $$3: Internal.InteractionHand_): Internal.InteractionResult;
        get gameModeForPlayer(): Internal.GameType
        get previousGameModeForPlayer(): Internal.GameType
        get survival(): boolean
        set level($$0: Internal.ServerLevel_)
        get creative(): boolean
        isDestroyingBlock: boolean;
    }
    type ServerPlayerGameMode_ = ServerPlayerGameMode;
    class ClientboundSetEntityDataPacket extends Internal.Record implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number, $$1: Internal.List_<Internal.SynchedEntityData$DataValue<any>>)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        id(): number;
        packedItems(): Internal.List<Internal.SynchedEntityData$DataValue<any>>;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean
        static readonly EOF_MARKER: 255;
    }
    type ClientboundSetEntityDataPacket_ = ClientboundSetEntityDataPacket;
    abstract class ColorModel implements Internal.Transparency {
        constructor(arg0: number)
        createCompatibleSampleModel(arg0: number, arg1: number): Internal.SampleModel;
        getRGB(arg0: number): number;
        getComponentSize(arg0: number): number;
        getRed(arg0: any): number;
        getUnnormalizedComponents(arg0: number[], arg1: number, arg2: number[], arg3: number): number[];
        abstract getGreen(arg0: number): number;
        getPixelSize(): number;
        getComponentSize(): number[];
        getDataElement(arg0: number[], arg1: number): number;
        hasAlpha(): boolean;
        getColorSpace(): Internal.ColorSpace;
        getNumComponents(): number;
        getBlue(arg0: any): number;
        createCompatibleWritableRaster(arg0: number, arg1: number): Internal.WritableRaster;
        getAlpha(arg0: any): number;
        getNumColorComponents(): number;
        getAlphaRaster(arg0: Internal.WritableRaster_): Internal.WritableRaster;
        getDataElement(arg0: number[], arg1: number): number;
        getRGB(arg0: any): number;
        isCompatibleSampleModel(arg0: Internal.SampleModel_): boolean;
        getNormalizedComponents(arg0: number[], arg1: number, arg2: number[], arg3: number): number[];
        getTransferType(): number;
        abstract getBlue(arg0: number): number;
        getComponents(arg0: any, arg1: number[], arg2: number): number[];
        isAlphaPremultiplied(): boolean;
        getNormalizedComponents(arg0: any, arg1: number[], arg2: number): number[];
        abstract getAlpha(arg0: number): number;
        coerceData(arg0: Internal.WritableRaster_, arg1: boolean): this;
        getDataElements(arg0: number[], arg1: number, arg2: any): any;
        getGreen(arg0: any): number;
        isCompatibleRaster(arg0: Internal.Raster_): boolean;
        getComponents(arg0: number, arg1: number[], arg2: number): number[];
        static getRGBdefault(): Internal.ColorModel;
        getDataElements(arg0: number[], arg1: number, arg2: any): any;
        getTransparency(): number;
        getDataElements(arg0: number, arg1: any): any;
        abstract getRed(arg0: number): number;
        get pixelSize(): number
        get componentSize(): number[]
        get colorSpace(): Internal.ColorSpace
        get numComponents(): number
        get numColorComponents(): number
        get transferType(): number
        get alphaPremultiplied(): boolean
        get RGBdefault(): Internal.ColorModel
        get transparency(): number
    }
    type ColorModel_ = ColorModel;
    class LinkedControllerItem extends Internal.Item implements Internal.UseFirstBehaviorItem, Internal.MenuProvider {
        constructor(properties: Internal.Item$Properties_)
        getDisplayName(): net.minecraft.network.chat.Component;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        createMenu(id: number, inv: Internal.Inventory_, player: Internal.Player_): Internal.AbstractContainerMenu;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        shouldCloseCurrentScreen(): boolean;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static getFrequencyItems(stack: Internal.ItemStack_): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        static getFrequencyItems(invNBT: Internal.CompoundTag_): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static toFrequency(controller: Internal.ItemStack_, slot: number): Internal.Couple<Internal.RedstoneLinkNetworkHandler$Frequency>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get displayName(): net.minecraft.network.chat.Component
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type LinkedControllerItem_ = LinkedControllerItem;
    abstract class ItemUpgrade extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemUpgrade_ = ItemUpgrade;
    class DragSourceDragEvent extends Internal.DragSourceEvent {
        constructor(arg0: Internal.DragSourceContext_, arg1: number, arg2: number, arg3: number)
        constructor(arg0: Internal.DragSourceContext_, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number)
        getTargetActions(): number;
        getUserAction(): number;
        getGestureModifiersEx(): number;
        getDropAction(): number;
        getGestureModifiers(): number;
        get targetActions(): number
        get userAction(): number
        get gestureModifiersEx(): number
        get dropAction(): number
        get gestureModifiers(): number
    }
    type DragSourceDragEvent_ = DragSourceDragEvent;
    class BlazeBurnerBlock extends Internal.HorizontalDirectionalBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.BlazeBurnerBlockEntity>, Internal.SpecialBlockItemRequirement {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.BlazeBurnerBlockEntity>): void;
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getRequiredItems(state: Internal.BlockState_, blockEntity: Internal.BlockEntity_): Internal.ItemRequirement;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static tryInsert(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, stack: Internal.ItemStack_, doNotConsume: boolean, forceOverflow: boolean, ctx: Internal.TransactionContext_): Internal.InteractionResultHolder<Internal.ItemStack>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.BlazeBurnerBlockEntity>;
        setLightEmission(v: number): void;
        getMod(): string;
        static buildLootTable(): Internal.LootTable$Builder;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.BlazeBurnerBlockEntity>;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getBlockEntityClass(): typeof Internal.BlazeBurnerBlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.BlazeBurnerBlockEntity;
        setDestroySpeed(v: number): void;
        static getHeatLevelOf(blockState: Internal.BlockState_): Internal.BlazeBurnerBlock$HeatLevel;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.BlazeBurnerBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static getLight(state: Internal.BlockState_): number;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.BlazeBurnerBlockEntity>
        get blockEntityClass(): typeof Internal.BlazeBurnerBlockEntity
        set destroySpeed(v: number)
        static readonly HEAT_LEVEL: Internal.EnumProperty<Internal.BlazeBurnerBlock$HeatLevel>;
    }
    type BlazeBurnerBlock_ = BlazeBurnerBlock;
    abstract class SingleVariantStorage <T extends Internal.TransferVariant<any>> extends Internal.SnapshotParticipant<any> implements Internal.SingleSlotStorage<T> {
        constructor()
        getResource(): any;
        getSlots(): Internal.List<Internal.SingleSlotStorage<T>>;
        iterator(): Internal.Iterator<Internal.StorageView<T>>;
        supportsInsertion(): boolean;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<T>>;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<T>>;
        extract(extractedVariant: T, maxAmount: number, transaction: Internal.TransactionContext_): number;
        supportsExtraction(): boolean;
        extract(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        getAmount(): number;
        isResourceBlank(): boolean;
        getSlotCount(): number;
        getSlot(slot: number): Internal.SingleSlotStorage<T>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: T, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        getUnderlyingView(): Internal.StorageView<T>;
        insert(insertedVariant: T, maxAmount: number, transaction: Internal.TransactionContext_): number;
        writeNbt(nbt: Internal.CompoundTag_): void;
        static asClass<T>(): Internal.Storage<T>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: T, maxAmount: number, transaction: Internal.TransactionContext_): number;
        insert(arg0: any, arg1: number, arg2: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: T): Internal.StorageView<T>;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        getCapacity(): number;
        get resource(): any
        get slots(): Internal.List<Internal.SingleSlotStorage<T>>
        get amount(): number
        get resourceBlank(): boolean
        get slotCount(): number
        get underlyingView(): Internal.StorageView<T>
        get version(): number
        get capacity(): number
        amount: number;
        variant: T;
    }
    type SingleVariantStorage_<T extends Internal.TransferVariant<any>> = SingleVariantStorage<T>;
    class MobEffect implements io.github.fabricators_of_create.porting_lib.extensions.extensions.MobEffectExtensions, Internal.MobEffectExtensions {
        getDisplayName(): net.minecraft.network.chat.Component;
        static getIdFromNullable($$0: Internal.MobEffect_): number;
        getCategory(): Internal.MobEffectCategory;
        getCurativeItems(): Internal.List<Internal.ItemStack>;
        addAttributeModifier($$0: Internal.Attribute_, $$1: string, $$2: number, $$3: Internal.AttributeModifier$Operation_): this;
        isInstantenous(): boolean;
        addAttributeModifiers($$0: Internal.LivingEntity_, $$1: Internal.AttributeMap_, $$2: number): void;
        setFactorDataFactory($$0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>): this;
        applyInstantenousEffect($$0: Internal.Entity_, $$1: Internal.Entity_, $$2: Internal.LivingEntity_, $$3: number, $$4: number): void;
        isBeneficial(): boolean;
        createFactorData(): Internal.Optional<Internal.MobEffectInstance$FactorData>;
        static byId($$0: number): Internal.MobEffect;
        getColor(): number;
        getAttributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>;
        removeAttributeModifiers($$0: Internal.LivingEntity_, $$1: Internal.AttributeMap_, $$2: number): void;
        applyEffectTick($$0: Internal.LivingEntity_, $$1: number): void;
        getAttributeModifierValue($$0: number, $$1: Internal.AttributeModifier_): number;
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
        getDescriptionId(): string;
        getRenderer(): Internal.MobEffectRenderer;
        isDurationEffectTick($$0: number, $$1: number): boolean;
        static getId($$0: Internal.MobEffect_): number;
        get displayName(): net.minecraft.network.chat.Component
        get category(): Internal.MobEffectCategory
        get curativeItems(): Internal.List<Internal.ItemStack>
        get instantenous(): boolean
        set factorDataFactory($$0: Internal.Supplier_<Internal.MobEffectInstance$FactorData>)
        get beneficial(): boolean
        get color(): number
        get attributeModifiers(): Internal.Map<Internal.Attribute, Internal.AttributeModifier>
        get descriptionId(): string
        get renderer(): Internal.MobEffectRenderer
    }
    type MobEffect_ = MobEffect | Special.MobEffect;
    class ItemRequirement {
        constructor(requiredItems: Internal.List_<Internal.ItemRequirement$StackRequirement>)
        constructor(stackRequirement: Internal.ItemRequirement$StackRequirement_)
        constructor(usage: Internal.ItemRequirement$ItemUseType_, item: Internal.Item_)
        constructor(usage: Internal.ItemRequirement$ItemUseType_, requiredItems: Internal.List_<Internal.ItemStack>)
        constructor(usage: Internal.ItemRequirement$ItemUseType_, stack: Internal.ItemStack_)
        static of(entity: Internal.Entity_): Internal.ItemRequirement;
        static of(state: Internal.BlockState_, be: Internal.BlockEntity_): Internal.ItemRequirement;
        isInvalid(): boolean;
        getRequiredItems(): Internal.List<Internal.ItemRequirement$StackRequirement>;
        isEmpty(): boolean;
        union(other: Internal.ItemRequirement_): this;
        get invalid(): boolean
        get requiredItems(): Internal.List<Internal.ItemRequirement$StackRequirement>
        get empty(): boolean
        static readonly NONE: Internal.ItemRequirement;
        static readonly INVALID: Internal.ItemRequirement;
    }
    type ItemRequirement_ = ItemRequirement;
    class ChainConveyorPackage$ChainConveyorPackagePhysicsData {
        constructor(this$0: Internal.ChainConveyorPackage_, serverPosition: Vec3d_)
        setBE(ccbe: Internal.ChainConveyorBlockEntity_): void;
        shouldTick(): boolean;
        set BE(ccbe: Internal.ChainConveyorBlockEntity_)
        beReference: Internal.WeakReference<Internal.ChainConveyorBlockEntity>;
        pos: Vec3d;
        yaw: number;
        prevTargetPos: Vec3d;
        flipped: boolean;
        motion: Vec3d;
        modelKey: ResourceLocation;
        prevPos: Vec3d;
        prevYaw: number;
        targetPos: Vec3d;
        lastTick: number;
    }
    type ChainConveyorPackage$ChainConveyorPackagePhysicsData_ = ChainConveyorPackage$ChainConveyorPackagePhysicsData;
    class FallenLogFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_, direction: Internal.Direction_, length: number): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type FallenLogFeature_ = FallenLogFeature;
    interface IBundledRedstoneBlock {
        abstract getBundledRedstoneOutput(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.Direction_): number;
        (arg0: Internal.Level, arg1: BlockPos, arg2: Internal.Direction): number;
    }
    type IBundledRedstoneBlock_ = IBundledRedstoneBlock;
    interface InfoBox$IInfoBoxHolder {
        abstract getInfoBox(arg0: Internal.ItemStack_, arg1: Internal.InfoBox_): Internal.InfoBox;
        (arg0: Internal.ItemStack, arg1: Internal.InfoBox): Internal.InfoBox_;
    }
    type InfoBox$IInfoBoxHolder_ = InfoBox$IInfoBoxHolder;
    class ComputerItem extends Internal.AbstractComputerItem {
        constructor(block: Internal.ComputerBlock_<any>, settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getComputerID(stack: Internal.ItemStack_): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        create(id: number, label: string): Internal.ItemStack;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ComputerItem_ = ComputerItem;
    class ArmorStandItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ArmorStandItem_ = ArmorStandItem;
    class SimpleContainer implements net.minecraft.world.Container, Internal.StackedContentsCompatible, Internal.SpecialLogicInventory {
        constructor(...$$0: Internal.ItemStack_[])
        constructor($$0: number)
        stopOpen($$0: Internal.Player_): void;
        static tryClear($$0: any): void;
        fabric_setSuppress(suppress: boolean): void;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        removeItem($$0: number, $$1: number): Internal.ItemStack;
        getSlots(): number;
        setChanged(): void;
        fabric_onFinalCommit(slot: number, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): void;
        getContainerSize(): number;
        setItem($$0: number, $$1: Internal.ItemStack_): void;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        removeItemNoUpdate($$0: number): Internal.ItemStack;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        removeItemType($$0: Internal.Item_, $$1: number): Internal.ItemStack;
        getItem($$0: number): Internal.ItemStack;
        addListener($$0: net.minecraft.world.ContainerListener_): void;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        isEmpty(): boolean;
        addItem($$0: Internal.ItemStack_): Internal.ItemStack;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        fromTag($$0: Internal.ListTag_): void;
        canAddItem($$0: Internal.ItemStack_): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        removeListener($$0: net.minecraft.world.ContainerListener_): void;
        getHeight(): number;
        countNonEmpty(): number;
        "redirect$cmi000$fabric-transfer-api-v1$fabric_redirectMarkDirty"(self: Internal.SimpleContainer_): void;
        asContainer(): net.minecraft.world.Container;
        createTag(): Internal.ListTag;
        removeAllItems(): Internal.List<Internal.ItemStack>;
        getAllItems(): Internal.List<Internal.ItemStack>;
        fillStackedContents($$0: Internal.StackedContents_): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        stillValid($$0: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        get containerSize(): number
        get width(): number
        get maxStackSize(): number
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        readonly items: Internal.NonNullList<Internal.ItemStack>;
    }
    type SimpleContainer_ = SimpleContainer;
}
declare namespace net.minecraft.world.inventory {
    interface ContainerListener {
        abstract dataChanged(arg0: Internal.AbstractContainerMenu_, arg1: number, arg2: number): void;
        abstract slotChanged(arg0: Internal.AbstractContainerMenu_, arg1: number, arg2: Internal.ItemStack_): void;
    }
    type ContainerListener_ = ContainerListener;
}
declare namespace dan200.computercraft.api.upgrades {
    class UpgradeData <T extends Internal.UpgradeBase> extends Internal.Record {
        constructor(upgrade: T, data: Internal.CompoundTag_)
        static of<T extends Internal.UpgradeBase>(upgrade: T, data: Internal.CompoundTag_): dan200.computercraft.api.upgrades.UpgradeData<T>;
        upgrade(): T;
        data(): Internal.CompoundTag;
        static copyOf<T extends Internal.UpgradeBase>(upgrade: dan200.computercraft.api.upgrades.UpgradeData_<T>): dan200.computercraft.api.upgrades.UpgradeData<T>;
        copy(): this;
        static ofDefault<T extends Internal.UpgradeBase>(upgrade: T): dan200.computercraft.api.upgrades.UpgradeData<T>;
        getUpgradeItem(): Internal.ItemStack;
        get upgradeItem(): Internal.ItemStack
    }
    type UpgradeData_<T extends Internal.UpgradeBase> = UpgradeData<T>;
}
